/**
 * Before/After Integration
 * Connect Before/After with the main app
 */

(function() {
  'use strict';

  // UI Elements
  const beforeAfterBtn = document.getElementById('beforeAfterBtn');
  const beforeAfterModeBtn = document.getElementById('beforeAfterModeBtn');
  const beforeAfterHeaderBtn = document.getElementById('beforeAfterHeaderBtn');

  // Save original image when first loaded
  const originalHandleFile = window.handleFile;
  if (originalHandleFile) {
    window.handleFile = function(file) {
      const result = originalHandleFile.call(this, file);
      
      // Save original after image loads
      setTimeout(() => {
        const previewImage = document.getElementById('previewImage');
        if (previewImage && previewImage.src) {
          window.beforeAfter.saveOriginal(previewImage.src);
          console.log('[Before/After] Original image saved on load');
          
          // Show floating button
          showFloatingButton();
        }
      }, 500);
      
      return result;
    };
  }

  // Show floating button
  function showFloatingButton() {
    const floatingBtn = document.getElementById('beforeAfterFloatingBtn');
    if (floatingBtn) {
      floatingBtn.style.display = 'flex';
      
      // Add pulse animation on first show
      const mainBtn = floatingBtn.querySelector('.floating-btn');
      if (mainBtn && !localStorage.getItem('beforeAfterShown')) {
        mainBtn.classList.add('first-time');
        localStorage.setItem('beforeAfterShown', 'true');
        
        // Remove animation after 6 seconds
        setTimeout(() => {
          mainBtn.classList.remove('first-time');
        }, 6000);
      }
    }

    // Show header button
    const headerBtn = document.getElementById('beforeAfterHeaderBtn');
    if (headerBtn) {
      headerBtn.style.display = 'flex';
    }
  }

  // Hide floating button
  function hideFloatingButton() {
    const floatingBtn = document.getElementById('beforeAfterFloatingBtn');
    if (floatingBtn) {
      floatingBtn.style.display = 'none';
    }

    // Hide header button
    const headerBtn = document.getElementById('beforeAfterHeaderBtn');
    if (headerBtn) {
      headerBtn.style.display = 'none';
    }
  }

  // Before/After button click
  if (beforeAfterBtn) {
    beforeAfterBtn.addEventListener('click', () => {
      window.beforeAfter.toggle();
    });
  }

  // Header button click
  if (beforeAfterHeaderBtn) {
    beforeAfterHeaderBtn.addEventListener('click', () => {
      window.beforeAfter.toggle();
    });
  }

  // Mode selector button click
  if (beforeAfterModeBtn) {
    beforeAfterModeBtn.addEventListener('click', () => {
      window.beforeAfter.showModeSelector();
    });
  }

  // Keyboard shortcut: C for Compare
  document.addEventListener('keydown', (e) => {
    // C key (not Ctrl+C)
    if (e.key === 'c' && !e.ctrlKey && !e.metaKey && !e.altKey) {
      // Check if not typing in input
      if (document.activeElement.tagName !== 'INPUT' && 
          document.activeElement.tagName !== 'TEXTAREA') {
        e.preventDefault();
        window.beforeAfter.toggle();
      }
    }
  });

  // Update original when applying filters (optional - for real-time comparison)
  // Uncomment if you want to update original on every change
  /*
  const originalApplyFilters = window.applyFilters;
  if (originalApplyFilters) {
    let isFirstApply = true;
    window.applyFilters = function(saveHistory = true) {
      // Save original on first apply
      if (isFirstApply && saveHistory) {
        const previewImage = document.getElementById('previewImage');
        if (previewImage && previewImage.src && !window.beforeAfter.hasOriginal()) {
          window.beforeAfter.saveOriginal(previewImage.src);
          isFirstApply = false;
        }
      }
      
      return originalApplyFilters.call(this, saveHistory);
    };
  }
  */

  // Clear original when clearing image
  const originalClearImage = window.clearImage;
  if (originalClearImage) {
    window.clearImage = function() {
      window.beforeAfter.clear();
      hideFloatingButton();
      return originalClearImage.call(this);
    };
  }

  // Update floating button state
  window.beforeAfter.updateFloatingButtonState = function(active) {
    const floatingBtn = document.getElementById('beforeAfterFloatingBtn');
    if (floatingBtn) {
      const mainBtn = floatingBtn.querySelector('.floating-btn');
      if (mainBtn) {
        if (active) {
          mainBtn.classList.add('active');
        } else {
          mainBtn.classList.remove('active');
        }
      }
    }
  };

  // Add tooltip info
  if (beforeAfterBtn) {
    beforeAfterBtn.title = 'Before/After Comparison (C)\n\nModes:\n• Toggle: Click to switch\n• Slider: Drag to reveal\n• Split: Vertical split\n• Side-by-Side: Two images';
  }

  console.log('[Before/After Integration] Initialized ✓');
  console.log('[Before/After Integration] Shortcut: C key');

})();
